<?php

declare(strict_types=1);

namespace Tfish\User;

/**
 * Tuskfish User module language constants (English).
 *
 * Translate this file to convert Tuskfish User module to another language.
 *
 * @copyright   Simon Wilkinson 2022+ (https://tuskfish.biz)
 * @license     https://www.gnu.org/licenses/old-licenses/gpl-2.0.en.html GNU General Public License (GPL) V2
 * @author      Simon Wilkinson <simon@isengard.biz>
 * @version     Release: 2.0
 * @since       2.0
 * @package     User
 */
// Language constants.
\define("TFISH_USERS", "Users");
\define("TFISH_USER_ADD", "Add user");
\define("TFISH_EDIT_USER", "Edit user");
\define("TFISH_USER_RESET_PASSWORD", "Reset password");
\define("TFISH_USER_GROUP", "Group");
\define("TFISH_USER_YUBIKEY_ID", "Yubikey ID");
\define("TFISH_ERROR_YUBIKEY_NOT_UNIQUE", "Yubikey ID not unique");
\define("TFISH_USER_LOGIN_ERRORS", "Login errors");
\define("TFISH_USER_SUPER_USER", "Admin");
\define("TFISH_USER_EDITOR", "Editor");
\define("TFISH_YUBIKEY_FIRST_12_CHARACTERS", "First 12 characters of Yubikey output. ID must be unique.");
\define("TFISH_USER_PRIVILEGES", "Privileges");
\define("TFISH_USER_ACTIVE", "Active");
\define("TFISH_USER_SUSPENDED", "Suspended");
